﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
if (typeof (question) === "undefined") {
    var question = {};
}

question.mid4040 = {
    //general options and settings
    opts: {
        questions: {
            hideByDefault: function () {
                return $('div[id$="TID1_QID4"],div[id$="TID1_QID5"],div[id$="TID1_QID11"],div[id$="TID1_QID12"],div[id$="TID1_QID14"],div[id$="TID1_QID15"],div[id$="TID1_QID17"],div[id$="TID1_QID18"]');
            }
        }
    },

    //hide questions by default
    hideQuestions: function () {
        var _me = this;

        $.each(_me.opts.questions.hideByDefault(), function (i, _divQ) {

            //set 'skipped' attribute
            $(_divQ).attr('skipped', true);
            $('[name^="grp"]', $(_divQ)).each(function () {
                var _name = $(this).attr('name');
                if (_name.indexOf("skip_") < 0) {
                    $(this).attr("name", "skip_" + _name);
                }
            });

            //no need to reset question's responses as is the first time loading and there are no answers
            //_me.clearQuestionResponses(_divQ);

            //hide question
            $(_divQ).hide();

        });

    },

    //initializing functions
    init: function (callback) {
        var _me = this;

        //wait for DOM readiness
        $(document).ready(function () {
            Ext.onReady(function () {
                setTimeout(function () {
                    //call functions here
                    _me.hideQuestions();

                    //Successful
                    if (callback) {
                        if (typeof (callback.success) == "function") {
                            callback.success();
                        }
                    }
                }, 1);
            });
        });
    }
};